﻿using System;
using System.Collections.Generic;
using System.Data;
using DataAccess.DataRows;

namespace DataAccess.DataTables
{
    public class GroupControlDataTable : DataTable
    {
        public GroupControlDataTable()
        {
            this.Columns.Add(new DataColumn("ID", typeof(int)));
            this.Columns.Add(new DataColumn("ENTRY", typeof(int)));
        }

        public GroupControlDataRow this[int index]
        {
            get
            {
                return (GroupControlDataRow)Rows[index];
            }
        }

        public void Add(GroupControlDataRow row)
        {
            this.Rows.Add(row);
        }

        public void Remove(GroupControlDataRow row)
        {
            this.Rows.Remove(row);
        }

        public GroupControlDataRow GetNewRow()
        {
            GroupControlDataRow row = (GroupControlDataRow)NewRow();
            return row;
        }

        protected override Type GetRowType()
        {
            return typeof(GroupControlDataRow);
        }

        protected override DataRow NewRowFromBuilder(DataRowBuilder builder)
        {
            return new GroupControlDataRow(builder);
        }

        public IEnumerator<GroupControlDataRow> GetEnumerator()
        {
            List<GroupControlDataRow> rows = new List<GroupControlDataRow>();

            for (int i = 0; i < this.Rows.Count; i++)
            {
                rows.Add((GroupControlDataRow)this.Rows[i]);
            }
            return rows.GetEnumerator();
        }
    }
}